/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.attachments;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentHelper;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentListPanel;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMItem;
import filenet.vw.toolkit.runtime.step.core.attachments.images.VWImageLoader;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWAttachmentToolBar
extends JToolBar
implements ActionListener,
ListSelectionListener,
Runnable {
    private static final int THREAD_WAIT_TIME_IN_MILLISECONDS = 30000;
    private static final int NUMBER_OF_OPS = 12;
    private static final int OP_ASSIGN = 0;
    private static final int OP_UNASSIGN = 1;
    private static final int OP_ADD = 2;
    private static final int OP_DELETE = 3;
    private static final int OP_VIEW = 4;
    private static final int OP_OPEN = 5;
    private static final int OP_CHECK_OUT = 6;
    private static final int OP_CHECK_OUT_OPEN = 7;
    private static final int OP_CHECK_IN = 8;
    private static final int OP_CANCEL_CHECK_OUT = 9;
    private static final int OP_VERSION_LIST = 10;
    private static final int OP_PROPERTIES = 11;
    private AbstractButton[] m_buttons = null;
    private VWAttachmentListPanel m_attachmentList = null;
    private Frame m_parentFrame = null;
    private JPopupMenu m_popupMenu = null;
    private JMenuItem[] m_menuItems = null;

    public VWAttachmentToolBar(VWAttachmentListPanel attachmentList) {
        try {
            this.m_attachmentList = attachmentList;
            this.setFloatable(false);
            this.setBorderPainted(false);
            this.createButtons();
            this.createContextMenu();
            if (this.m_attachmentList != null) {
                this.m_attachmentList.addListSelectionListener(this);
                this.m_attachmentList.setToolBar(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JPopupMenu getContextMenu() {
        return this.m_popupMenu;
    }

    public void setParentFrame(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object actionSource = event.getSource();
            if (this.m_attachmentList == null) {
                return;
            }
            VWIDMItem idmItem = this.m_attachmentList.getSelectedItem();
            if (actionSource.equals(this.m_buttons[0]) || actionSource.equals(this.m_menuItems[0])) {
                this.m_attachmentList.assignDocument(idmItem);
            } else if (actionSource.equals(this.m_buttons[1]) || actionSource.equals(this.m_menuItems[1])) {
                this.m_attachmentList.unassignDocument(idmItem);
            } else if (actionSource.equals(this.m_buttons[2]) || actionSource.equals(this.m_menuItems[2])) {
                this.m_attachmentList.addAttachment(idmItem);
            } else if (actionSource.equals(this.m_buttons[3]) || actionSource.equals(this.m_menuItems[3])) {
                this.m_attachmentList.deleteItem(idmItem);
            } else {
                VWAttachmentHelper vwAttachmentHelper = idmItem.getAttachmentHelper();
                if (actionSource.equals(this.m_buttons[4]) || actionSource.equals(this.m_menuItems[4])) {
                    vwAttachmentHelper.view();
                } else if (actionSource.equals(this.m_buttons[5]) || actionSource.equals(this.m_menuItems[5])) {
                    try {
                        vwAttachmentHelper.open();
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        JOptionPane.showMessageDialog(this.m_parentFrame, ex.getMessage(), VWResource.s_unableToOpenAttachment, 0);
                    }
                } else if (actionSource.equals(this.m_buttons[6]) || actionSource.equals(this.m_menuItems[6])) {
                    vwAttachmentHelper.checkout();
                } else if (actionSource.equals(this.m_buttons[7]) || actionSource.equals(this.m_menuItems[7])) {
                    vwAttachmentHelper.checkoutAndOpen();
                } else if (actionSource.equals(this.m_buttons[8]) || actionSource.equals(this.m_menuItems[8])) {
                    vwAttachmentHelper.checkin();
                } else if (actionSource.equals(this.m_buttons[9]) || actionSource.equals(this.m_menuItems[9])) {
                    vwAttachmentHelper.cancelCheckout();
                } else if (actionSource.equals(this.m_buttons[10]) || actionSource.equals(this.m_menuItems[10])) {
                    vwAttachmentHelper.showVersionListWindow();
                } else if (actionSource.equals(this.m_buttons[11]) || actionSource.equals(this.m_menuItems[11])) {
                    vwAttachmentHelper.showPropertiesDialog();
                }
                if (vwAttachmentHelper.isDocument() && !this.m_attachmentList.getSessionInfo().isWorkPlaceWebApp()) {
                    Thread updateThread = new Thread((Runnable)this, "VWAttachmentToolBar");
                    updateThread.start();
                }
            }
            this.refreshSelectedItemState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getMessage(), VWResource.s_error, 0);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event != null && event.getValueIsAdjusting()) {
            return;
        }
        this.refreshSelectedItemState();
    }

    public void run() {
        try {
            Thread.sleep(30000L);
            this.refreshSelectedItemState();
        }
        catch (InterruptedException ie) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createButtons() {
        try {
            this.m_buttons = new AbstractButton[12];
            this.m_buttons[0] = this.createButton("assign.gif", VWResource.s_assignAttachment);
            if (this.m_buttons[0] != null) {
                this.add(this.m_buttons[0]);
                this.m_buttons[0].setRolloverEnabled(false);
            }
            this.m_buttons[1] = this.createButton("unassign.gif", VWResource.s_unassignAttachment);
            if (this.m_buttons[1] != null) {
                this.add(this.m_buttons[1]);
                this.m_buttons[1].setRolloverEnabled(false);
            }
            this.m_buttons[2] = this.createButton("add.gif", VWResource.s_addAttachmentToArray);
            if (this.m_buttons[2] != null) {
                this.add(this.m_buttons[2]);
                this.m_buttons[2].setRolloverEnabled(false);
            }
            this.m_buttons[3] = this.createButton("delete.gif", VWResource.s_deleteAttachmentFromArray);
            if (this.m_buttons[3] != null) {
                this.add(this.m_buttons[3]);
                this.m_buttons[3].setRolloverEnabled(false);
            }
            this.addSeparator();
            if (this.m_attachmentList != null && !this.m_attachmentList.getSessionInfo().isWorkPlaceWebApp()) {
                this.m_buttons[4] = this.createButton("view.gif", VWResource.s_viewDocument);
                if (this.m_buttons[4] != null) {
                    this.add(this.m_buttons[4]);
                    this.m_buttons[4].setRolloverEnabled(false);
                }
            }
            this.m_buttons[5] = this.createButton("open.gif", VWResource.s_open);
            if (this.m_buttons[5] != null) {
                this.add(this.m_buttons[5]);
                this.m_buttons[5].setRolloverEnabled(false);
            }
            this.addSeparator();
            this.m_buttons[6] = this.createButton("checkout.gif", VWResource.s_checkoutDocument);
            if (this.m_buttons[6] != null) {
                this.add(this.m_buttons[6]);
                this.m_buttons[6].setRolloverEnabled(false);
            }
            this.m_buttons[7] = this.createButton("chkoutopen.gif", VWResource.s_checkoutAndOpen);
            if (this.m_buttons[7] != null) {
                this.add(this.m_buttons[7]);
                this.m_buttons[7].setRolloverEnabled(false);
            }
            this.m_buttons[8] = this.createButton("checkin.gif", VWResource.s_checkinDocument);
            if (this.m_buttons[8] != null) {
                this.add(this.m_buttons[8]);
                this.m_buttons[8].setRolloverEnabled(false);
            }
            this.m_buttons[9] = this.createButton("cnclchkout.gif", VWResource.s_cancelCheckout);
            if (this.m_buttons[9] != null) {
                this.add(this.m_buttons[9]);
                this.m_buttons[9].setRolloverEnabled(false);
            }
            this.m_buttons[10] = this.createButton("verlist.gif", VWResource.s_versionList);
            if (this.m_buttons[10] != null) {
                this.add(this.m_buttons[10]);
                this.m_buttons[10].setRolloverEnabled(false);
            }
            this.addSeparator();
            this.m_buttons[11] = this.createButton("proplink.gif", VWResource.s_properties);
            if (this.m_buttons[11] != null) {
                this.add(this.m_buttons[11]);
                this.m_buttons[11].setRolloverEnabled(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private AbstractButton createButton(String iconName, String name) {
        try {
            AbstractButton button = VWImageLoader.createToolBarButton(iconName, name, false);
            if (button != null) {
                button.setEnabled(false);
                button.addActionListener(this);
                return button;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void createContextMenu() {
        try {
            this.m_popupMenu = new JPopupMenu();
            this.m_menuItems = new JMenuItem[12];
            this.m_menuItems[0] = new JMenuItem(VWResource.s_assignAttachment);
            this.m_menuItems[0].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[0]);
            this.m_menuItems[1] = new JMenuItem(VWResource.s_unassignAttachment);
            this.m_menuItems[1].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[1]);
            this.m_menuItems[2] = new JMenuItem(VWResource.s_addAttachmentToArray);
            this.m_menuItems[2].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[2]);
            this.m_menuItems[3] = new JMenuItem(VWResource.s_deleteAttachmentFromArray);
            this.m_menuItems[3].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[3]);
            this.m_popupMenu.addSeparator();
            if (this.m_attachmentList != null && !this.m_attachmentList.getSessionInfo().isWorkPlaceWebApp()) {
                this.m_menuItems[4] = new JMenuItem(VWResource.s_viewDocument);
                this.m_menuItems[4].addActionListener(this);
                this.m_popupMenu.add(this.m_menuItems[4]);
            }
            this.m_menuItems[5] = new JMenuItem(VWResource.s_open);
            this.m_menuItems[5].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[5]);
            this.m_popupMenu.addSeparator();
            this.m_menuItems[6] = new JMenuItem(VWResource.s_checkoutDocument);
            this.m_menuItems[6].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[6]);
            this.m_menuItems[7] = new JMenuItem(VWResource.s_checkoutAndOpen);
            this.m_menuItems[7].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[7]);
            this.m_menuItems[8] = new JMenuItem(VWResource.s_checkinDocument);
            this.m_menuItems[8].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[8]);
            this.m_menuItems[9] = new JMenuItem(VWResource.s_cancelCheckout);
            this.m_menuItems[9].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[9]);
            this.m_menuItems[10] = new JMenuItem(VWResource.s_versionList);
            this.m_menuItems[10].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[10]);
            this.m_popupMenu.addSeparator();
            this.m_menuItems[11] = new JMenuItem(VWResource.s_properties);
            this.m_menuItems[11].addActionListener(this);
            this.m_popupMenu.add(this.m_menuItems[11]);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSelectedItemState() {
        block26: {
            try {
                if (this.m_parentFrame != null) {
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                }
                if (this.m_attachmentList == null || this.m_attachmentList != null && this.m_attachmentList.getSelectedItem() == null) {
                    for (int nIndex = 0; nIndex < 12; ++nIndex) {
                        if (this.m_buttons[nIndex] != null) {
                            this.m_buttons[nIndex].setEnabled(false);
                        }
                        if (this.m_menuItems[nIndex] == null) continue;
                        this.m_menuItems[nIndex].setEnabled(false);
                    }
                    break block26;
                }
                boolean isImageLibrary = false;
                boolean canAssign = false;
                boolean canAdd = false;
                boolean canDelete = false;
                boolean canView = false;
                boolean canOpen = false;
                boolean canCheckout = false;
                boolean canCheckin = false;
                boolean canCancelCheckout = false;
                boolean canViewVersion = false;
                boolean canViewProperties = false;
                boolean isCheckedout = false;
                boolean isFolder = false;
                boolean isStoredSearch = false;
                boolean isUndefined = false;
                boolean isURL = false;
                VWIDMItem idmItem = this.m_attachmentList.getSelectedItem();
                try {
                    VWAttachmentHelper vwAttachmentHelper = idmItem.getAttachmentHelper();
                    if (vwAttachmentHelper != null && idmItem.getAttachment() != null) {
                        vwAttachmentHelper.updateCheckoutStatus();
                        if (idmItem.getAttachment().getType() != 0 && idmItem.getAttachment().getType() != 5) {
                            this.m_attachmentList.syncItemName(idmItem);
                            isImageLibrary = vwAttachmentHelper.isISItem();
                        }
                        switch (idmItem.getAttachment().getType()) {
                            case 2: {
                                canViewProperties = true;
                                isFolder = true;
                                break;
                            }
                            case 4: {
                                canViewProperties = true;
                                isStoredSearch = true;
                                break;
                            }
                            case 3: {
                                if (vwAttachmentHelper.isDocument()) {
                                    canView = vwAttachmentHelper.canView();
                                    canOpen = vwAttachmentHelper.canOpen();
                                    isCheckedout = vwAttachmentHelper.isCheckedOut();
                                    canCheckin = vwAttachmentHelper.canCheckin();
                                    canCheckout = vwAttachmentHelper.canCheckout();
                                    canCancelCheckout = vwAttachmentHelper.canCancelCheckout();
                                }
                                canViewProperties = true;
                                canViewVersion = true;
                                break;
                            }
                            case 5: {
                                isURL = true;
                                break;
                            }
                            case 0: {
                                isUndefined = true;
                            }
                        }
                    } else {
                        isUndefined = true;
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(this.m_parentFrame, ex.getMessage(), VWResource.s_attachmentError, 0);
                }
                if (!idmItem.isReadOnly()) {
                    canAssign = true;
                }
                if (!idmItem.isReadOnly() && idmItem.isArray()) {
                    canAdd = true;
                    canDelete = !idmItem.isEmpty();
                }
                this.enableButton(this.m_buttons[0], canAssign);
                this.enableButton(this.m_buttons[1], canAssign);
                this.enableButton(this.m_buttons[2], canAdd);
                this.enableButton(this.m_buttons[3], canDelete);
                this.enableButton(this.m_buttons[4], canView);
                this.enableButton(this.m_buttons[5], canOpen || isFolder || isStoredSearch || isURL);
                this.enableButton(this.m_buttons[6], !isImageLibrary && !isCheckedout && canCheckout);
                this.enableButton(this.m_buttons[7], !isImageLibrary && !isCheckedout && canCheckout && canOpen);
                this.enableButton(this.m_buttons[8], !isImageLibrary && isCheckedout && canCheckin);
                this.enableButton(this.m_buttons[9], !isImageLibrary && isCheckedout && canCancelCheckout);
                this.enableButton(this.m_buttons[10], !isImageLibrary && !isUndefined && canViewVersion);
                this.enableButton(this.m_buttons[11], !isUndefined && canViewProperties);
                this.m_menuItems[0].setEnabled(canAssign);
                this.m_menuItems[1].setEnabled(canAssign);
                this.m_menuItems[2].setEnabled(canAdd);
                this.m_menuItems[3].setEnabled(canDelete);
                if (this.m_menuItems[4] != null) {
                    this.m_menuItems[4].setEnabled(canView);
                }
                this.m_menuItems[5].setEnabled(canOpen || isFolder || isStoredSearch || isURL);
                this.m_menuItems[6].setEnabled(!isImageLibrary && !isCheckedout && canCheckout);
                this.m_menuItems[7].setEnabled(!isImageLibrary && !isCheckedout && canCheckout && canOpen);
                this.m_menuItems[8].setEnabled(!isImageLibrary && isCheckedout && canCheckin);
                this.m_menuItems[9].setEnabled(!isImageLibrary && isCheckedout && canCancelCheckout);
                this.m_menuItems[10].setEnabled(!isImageLibrary && !isUndefined && canViewVersion);
                this.m_menuItems[11].setEnabled(!isUndefined && canViewProperties);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            finally {
                this.m_attachmentList.refreshSelectedItemState();
                if (this.m_parentFrame != null) {
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private void enableButton(AbstractButton button, boolean bEnabled) {
        if (button != null) {
            button.setEnabled(bEnabled);
            button.setRolloverEnabled(bEnabled);
        }
    }
}

